<?php $__env->startSection('content'); ?>

<section data-anim-wrap class="masthead -type-3 relative z-5">
    <div data-anim-child="fade delay-1" class="masthead__bg bg-dark-3">
      <img src="<?php echo e(asset('assets/img/masthead/3/bg.png')); ?>" alt="image">
    </div>
    <div class="container">
      <div class="row justify-center">
        <div class="col-xl-10">
          <div class="text-center">
            <h1 data-anim-child="slide-up delay-4" class="text-60 lg:text-40 md:text-30 text-white">Discover Your World</h1>
            <p data-anim-child="slide-up delay-5" class="text-white mt-5">Discover amzaing places at exclusive deals</p>
          </div>

          <div data-anim-child="slide-up delay-6" class="masthead__tabs">
            <div class="tabs -bookmark js-tabs">
              <div class="tabs__controls d-flex items-center js-tabs-controls">

                <div class="">
                  <button class="tabs__button px-30 py-20 rounded-4 fw-600 text-white js-tabs-button is-tab-el-active" data-tab-target=".-tab-item-1">
                    <i class="icon-tickets text-20 mr-10"></i>
                    Flights
                  </button>
                </div>
                <div class="">
                    <button class="tabs__button px-30 py-20 rounded-4 fw-600 text-white js-tabs-button" data-tab-target=".-tab-item-2">
                        <i class="icon-destination text-20 mr-10"></i>
                        Tours
                    </button>
                </div>

              </div>

              <div class="tabs__content js-tabs-content">

                <div class="tabs__pane -tab-item-1 is-tab-el-active">
                  <div class="mainSearch bg-white pr-20 py-20 lg:px-20 lg:pt-5 lg:pb-20 rounded-4 shadow-1">
                    <div class="flightSearch m-4">
                        <form action="<?php echo e(route('submit-search')); ?>" method="get">
                            <div class="container">
                                <div class="row">
                                    <div class="col-md-4">
                                        <input style="width: 20px !important;" type="radio" name="type" id="one-way">
                                        <label for="one-way">One-Way</label>
                                        <input style="width: 20px !important;" type="radio" name="type" id="round-trip">
                                        <label for="round-trip">Round-Trip</label>
                                    </div>
                                </div>
                                <div class="row mt-30">
                                    <div class="col-md-4">
                                        <label for="from">From</label>
                                        <select class="select2" name="from" id="from" required>
                                            <option value="" disabled selected>Where are you flying from?</option>
                                            <?php $__currentLoopData = $allAirports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $airport): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($airport->iata_code); ?>"><?php echo e($airport->iata_code); ?> - <?php echo e($airport->airport_name); ?> - <?php echo e($airport->city_name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="col-md-4">
                                        <label for="to">To</label>
                                        <select class="select2" name="to" id="to" required>
                                            <option value="" disabled selected>Where are you flying to?</option>
                                            <?php $__currentLoopData = $allAirports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $airport): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($airport->iata_code); ?>"><?php echo e($airport->iata_code); ?> - <?php echo e($airport->airport_name); ?> - <?php echo e($airport->city_name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="col-md-2">
                                        <label for="depart_date">Depart Date</label>
                                        <input type="date" name="depart_date" id="depart" required>
                                    </div>
                                    <div class="col-md-2" id="hideReturnDate">
                                        <label for="return-date">Return Date</label>
                                        <input type="date" name="return_date" id="return">
                                    </div>
                                </div>
                                <div class="row mt-30">
                                    <div class="col-md-3 mt-20">
                                        <input style="width: 20px !important;" type="checkbox" name="direct-flight-only" id="direct-flight-only">
                                        <label for="direct-flight-only">Direct Flight Only</label>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="searchMenu-guests px-30 lg:py-20 lg:px-0 js-form-dd js-form-counters">

                                            <div data-x-dd-click="searchMenu-guests">
                                              <h4 class="text-15 fw-500 ls-2 lh-16">Passengers</h4>

                                              <div class="text-15 text-light-1 ls-2 lh-16">
                                                <span class="js-count-adult">1</span> adults
                                                <input type="hidden" name="js-count-adult" class="js-count-adult" value="1">
                                                -
                                                <span class="js-count-child">0</span> childeren
                                                <input type="hidden" name="js-count-child" class="js-count-child" value="0">
                                                -
                                                <span class="js-count-infants">0</span> Infants
                                                <input type="hidden" name="js-count-infants" class="js-count-infants" value="0">
                                              </div>
                                            </div>


                                            <div class="searchMenu-guests__field shadow-2" data-x-dd="searchMenu-guests" data-x-dd-toggle="-is-active">
                                              <div class="bg-white px-30 py-30 rounded-4">
                                                <div class="row y-gap-10 justify-between items-center">
                                                  <div class="col-auto">
                                                    <div class="text-15 fw-500">Adults</div>
                                                    <div class="text-14 lh-12 text-light-1 mt-5"> > 12 Years</div>
                                                  </div>

                                                  <div class="col-auto">
                                                    <div class="d-flex items-center js-counter" data-value-change=".js-count-adult">
                                                      <span class="button -outline-blue-1 text-blue-1 size-38 rounded-4 js-down">
                                                        <i class="icon-minus text-12"></i>
                                                      </span>

                                                      <div class="flex-center size-20 ml-15 mr-15">
                                                        <div class="text-15 js-count">1</div>
                                                      </div>

                                                      <span class="button -outline-blue-1 text-blue-1 size-38 rounded-4 js-up">
                                                        <i class="icon-plus text-12"></i>
                                                      </span>
                                                    </div>
                                                  </div>
                                                </div>

                                                <div class="border-top-light mt-24 mb-24"></div>

                                                <div class="row y-gap-10 justify-between items-center">
                                                  <div class="col-auto">
                                                    <div class="text-15 lh-12 fw-500">Children</div>
                                                    <div class="text-14 lh-12 text-light-1 mt-5">2 - 12 Years</div>
                                                  </div>

                                                  <div class="col-auto">
                                                    <div class="d-flex items-center js-counter" data-value-change=".js-count-child">
                                                      <span class="button -outline-blue-1 text-blue-1 size-38 rounded-4 js-down">
                                                        <i class="icon-minus text-12"></i>
                                                      </span>

                                                      <div class="flex-center size-20 ml-15 mr-15">
                                                        <div class="text-15 js-count">0</div>
                                                      </div>

                                                      <span class="button -outline-blue-1 text-blue-1 size-38 rounded-4 js-up">
                                                        <i class="icon-plus text-12"></i>
                                                      </span>
                                                    </div>
                                                  </div>
                                                </div>

                                                <div class="border-top-light mt-24 mb-24"></div>

                                                <div class="row y-gap-10 justify-between items-center">
                                                  <div class="col-auto">
                                                    <div class="text-15 fw-500">Infants</div>
                                                    <div class="text-14 lh-12 text-light-1 mt-5"> < 2 Years</div>
                                                  </div>

                                                  <div class="col-auto">
                                                    <div class="d-flex items-center js-counter" data-value-change=".js-count-infants">
                                                      <span class="button -outline-blue-1 text-blue-1 size-38 rounded-4 js-down">
                                                        <i class="icon-minus text-12"></i>
                                                      </span>

                                                      <div class="flex-center size-20 ml-15 mr-15">
                                                        <div class="text-15 js-count">0</div>
                                                      </div>

                                                      <span class="button -outline-blue-1 text-blue-1 size-38 rounded-4 js-up">
                                                        <i class="icon-plus text-12"></i>
                                                      </span>
                                                    </div>
                                                  </div>
                                                </div>
                                              </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-2 mt-20">
                                        <select name="flight-type" id="flight-type">
                                            <option value="economy">Economy</option>
                                            <option value="premium-economy">Premium Economy</option>
                                            <option value="business-class">Business Class</option>
                                            <option value="first-class">First Class</option>
                                        </select>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="button-item">
                                            <button class="mainSearch__submit button -yellow-new py-15 px-35 h-60 col-12 rounded-4 bg-dark-new text-white">
                                              <i class="icon-search text-20 mr-10"></i>
                                              Search
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                  </div>
                </div>

                <div class="tabs__pane -tab-item-2">
                    <div class="mainSearch bg-white pr-20 py-20 lg:px-20 lg:pt-5 lg:pb-20 rounded-4 shadow-1">
                      <div class="flightSearch m-4">
                        <form action="<?php echo e(route('submit-tour')); ?>" method="get">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="col-lg-4 mt-30">
                                    <label for="name">Name</label>
                                    <input style="padding-left:10px;" type="text" name="name" id="name" placeholder="Enter Name" value="<?php echo e(old('name')); ?>" required>
                                </div>
                                <div class="col-lg-4 mt-30">
                                    <label for="email">Email</label>
                                    <input style="padding-left:10px;" type="email" name="email" id="email" placeholder="Enter Email" value="<?php echo e(old('email')); ?>" required>
                                </div>
                                <div class="col-lg-4 mt-30">
                                    <label for="phone">Phone No.</label>
                                    <input style="padding-left:10px;" type="text" name="phone" id="phone" placeholder="Enter Phone No." value="<?php echo e(old('phone')); ?>" required>
                                </div>
                                <div class="col-lg-4 mt-30">
                                    <label for="no_of_traveler">No. of Travelers</label>
                                    <input style="padding-left:10px;" type="text" name="no_of_traveler" id="no_of_traveler" placeholder="Enter No. of Travelers" value="<?php echo e(old('no_of_traveler')); ?>" required>
                                </div>
                                <div class="col-lg-4 mt-30">
                                    <label for="selected_tour">Where would you like to Travel?</label>
                                    <select style="padding-left:10px;" name="selected_tour" id="selected_tour" required>
                                        <option value="" disabled selected>Select Tour</option>
                                        <option value="thailand"> Thailand Tour </option>
                                        <option value="baku_and_istanbul"> Baku & Istanbul Combo Tour </option>
                                        <option value="srilanka">Best of Srilanka Tour</option>
                                        <option value="tomatina">4 Countries With Tomatina</option>
                                    </select>
                                </div>
                                <div class="col-lg-4 mt-30">
                                    <label for="depart_date">Departure Date</label>
                                    <input type="date" name="depart_date" id="depart" required value="<?php echo e(old('depart_date')); ?>"  required>
                                </div>
                                <div class="col-lg-10 mt-30">
                                    <label for="message">Message</label>
                                    <textarea style="padding-left:10px;" name="message" id="message" cols="30" rows="3" placeholder="Write your message"><?php echo e(old('message')); ?></textarea>
                                </div>
                                <div class="col-lg-2" style="display: flex; align-items: end;">
                                    <div class="button-item">
                                        <button type="submit" class="mainSearch__submit button -yellow-new py-15 px-35 col-12 rounded-4 bg-dark-new text-white">
                                            Submit
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </form>
                      </div>
                    </div>
                  </div>

              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>

  

  <section class="layout-pt-md layout-pb-md">
    <div class="container">
      <div class="row justify-center text-center">
        <div class="col-auto">
          <div class="sectionTitle -md">
            <h2 class="sectionTitle__title">Why Choose Us</h2>
            <p class=" sectionTitle__text mt-5 sm:mt-0">These popular destinations have a lot to offer</p>
          </div>
        </div>
      </div>

      <div class="row y-gap-40 justify-between pt-50">

        <div class="col-lg-3 col-sm-6">

          <div class="featureIcon -type-1 ">
            <div class="d-flex justify-center">
              <img src="#" data-src="<?php echo e(asset('assets/img/featureIcons/3/1.svg')); ?>" alt="image" class="js-lazy">
            </div>

            <div class="text-center mt-30">
              <h4 class="text-18 fw-500">Best Price Guarantee</h4>
              <p class="text-15 mt-10">Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p>
            </div>
          </div>

        </div>

        <div class="col-lg-3 col-sm-6">

          <div class="featureIcon -type-1 ">
            <div class="d-flex justify-center">
              <img src="#" data-src="<?php echo e(asset('assets/img/featureIcons/3/2.svg')); ?>" alt="image" class="js-lazy">
            </div>

            <div class="text-center mt-30">
              <h4 class="text-18 fw-500">Easy & Quick Booking</h4>
              <p class="text-15 mt-10">Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p>
            </div>
          </div>

        </div>

        <div class="col-lg-3 col-sm-6">

          <div class="featureIcon -type-1 ">
            <div class="d-flex justify-center">
              <img src="#" data-src="<?php echo e(asset('assets/img/featureIcons/3/3.svg')); ?>" alt="image" class="js-lazy">
            </div>

            <div class="text-center mt-30">
              <h4 class="text-18 fw-500">Customer Care 24/7</h4>
              <p class="text-15 mt-10">Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p>
            </div>
          </div>

        </div>

      </div>
    </div>
  </section>

  <section class="layout-pt-md layout-pb-md">
    <div data-anim-wrap class="container">
      <div data-anim-child="slide-up" class="row y-gap-20 justify-between items-end">
        <div class="col-auto">
          <div class="sectionTitle -md">
            <h2 class="sectionTitle__title">Most Popular Tours</h2>
            <p class=" sectionTitle__text mt-5 sm:mt-0">Interdum et malesuada fames ac ante ipsum</p>
          </div>
        </div>

        <div class="col-auto">

          <a href="<?php echo e(route('all-tours')); ?>" class="-md -yellow-new bg-dark-new button text-white">
            More <div class="icon-arrow-top-right ml-15"></div>
          </a>

        </div>
      </div>

      <div class="row y-gap-30 pt-40 sm:pt-20">

        <div data-anim-child="slide-up delay-1" class="col-xl-3 col-lg-3 col-sm-6">

          <a href="<?php echo e(route('thailand-tour')); ?>" class="tourCard -type-1 rounded-4 ">
            <div class="tourCard__image">

              <div class="cardImage ratio ratio-1:1">
                <div class="cardImage__content">

                  <img class="rounded-4 col-12" src="<?php echo e(asset('assets/img/tours/Thailand.jpg')); ?>" alt="image">


                </div>

                <div class="cardImage__wishlist">
                  <button class="button -blue-1 bg-white size-30 rounded-full shadow-2">
                    <i class="icon-heart text-12"></i>
                  </button>
                </div>


                <div class="cardImage__leftBadge">
                  <div class="py-5 px-15 rounded-right-4 text-12 lh-16 fw-500 uppercase bg-dark-1 text-white">
                    LIKELY TO SELL OUT*
                  </div>
                </div>

              </div>

            </div>

            <div class="tourCard__content mt-10">
              <div class="d-flex items-center lh-14 mb-5">
                
                
                <div class="text-14 text-light-1">10 Days Tour</div>
              </div>

              <h4 class="tourCard__title text-dark-1 text-18 lh-16 fw-500">
                <span>Thailand Tour</span>
              </h4>
              <p class="text-light-1 lh-14 text-14 mt-5"><strong>Service level:</strong> Upgraded</p>
              <p class="text-light-1 lh-14 text-14 mt-5"><strong>Activity level:</strong> High</p>
              <p class="text-light-1 lh-14 text-14 mt-5"><strong> Group size:</strong> Private group</p>

              <div class="row justify-between items-center pt-15">
                

                <div class="col-auto">
                  <div class="text-14 text-light-1">
                    From
                    <span class="text-16 fw-500 text-dark-1">$800 Per Person</span>
                  </div>
                </div>
              </div>
            </div>
          </a>

        </div>

        <div data-anim-child="slide-up delay-2" class="col-xl-3 col-lg-3 col-sm-6">

          <a href="<?php echo e(route('baku-and-istanbul-tour')); ?>" class="tourCard -type-1 rounded-4 ">
            <div class="tourCard__image">

              <div class="cardImage ratio ratio-1:1">
                <div class="cardImage__content">


                  <div class="cardImage-slider rounded-4 overflow-hidden js-cardImage-slider">
                    <div class="swiper-wrapper">

                      <div class="swiper-slide">
                        <img class="col-12" src="<?php echo e(asset('assets/img/tours/baku.jpg')); ?>" alt="image">
                      </div>

                      <div class="swiper-slide">
                        <img class="col-12" src="<?php echo e(asset('assets/img/tours/istanbul.jpg')); ?>" alt="image">
                      </div>

                      <div class="swiper-slide">
                        <img class="col-12" src="<?php echo e(asset('assets/img/tours/baku-instanbul.jpg')); ?>" alt="image">
                      </div>

                    </div>

                    <div class="cardImage-slider__pagination js-pagination"></div>

                    <div class="cardImage-slider__nav -prev">
                      <button class="button -blue-1 bg-white size-30 rounded-full shadow-2 js-prev">
                        <i class="icon-chevron-left text-10"></i>
                      </button>
                    </div>

                    <div class="cardImage-slider__nav -next">
                      <button class="button -blue-1 bg-white size-30 rounded-full shadow-2 js-next">
                        <i class="icon-chevron-right text-10"></i>
                      </button>
                    </div>
                  </div>

                </div>

                <div class="cardImage__wishlist">
                  <button class="button -blue-1 bg-white size-30 rounded-full shadow-2">
                    <i class="icon-heart text-12"></i>
                  </button>
                </div>


              </div>

            </div>

            <div class="tourCard__content mt-10">
              <div class="d-flex items-center lh-14 mb-5">
                
                <div class="text-14 text-light-1">7 Days Tour</div>
              </div>

              <h4 class="tourCard__title text-dark-1 text-18 lh-16 fw-500">
                <span>Baku & Istanbul Combo Tour</span>
              </h4>

              <p class="text-light-1 lh-14 text-14 mt-5"><strong>Service level:</strong> Upgraded</p>
              <p class="text-light-1 lh-14 text-14 mt-5"><strong>Activity level:</strong> Moderate</p>
              <p class="text-light-1 lh-14 text-14 mt-5"><strong> Group size:</strong> Private group</p>

              <div class="row justify-between items-center pt-15">
                

                <div class="col-auto">
                  <div class="text-14 text-light-1">
                    From
                    <span class="text-16 fw-500 text-dark-1">$1000 Per Person</span>
                  </div>
                </div>
              </div>
            </div>
          </a>

        </div>

        <div data-anim-child="slide-up delay-3" class="col-xl-3 col-lg-3 col-sm-6">

          <a href="<?php echo e(route('srilanka-tour')); ?>" class="tourCard -type-1 rounded-4 ">
            <div class="tourCard__image">

              <div class="cardImage ratio ratio-1:1">
                <div class="cardImage__content">

                  <img class="rounded-4 col-12" src="<?php echo e(asset('assets/img/tours/srilanka.jpg')); ?>" alt="image">


                </div>

                <div class="cardImage__wishlist">
                  <button class="button -blue-1 bg-white size-30 rounded-full shadow-2">
                    <i class="icon-heart text-12"></i>
                  </button>
                </div>


                <div class="cardImage__leftBadge">
                  <div class="py-5 px-15 rounded-right-4 text-12 lh-16 fw-500 uppercase bg-blue-1 text-white">
                    Best Seller
                  </div>
                </div>

              </div>

            </div>

            <div class="tourCard__content mt-10">
              <div class="d-flex items-center lh-14 mb-5">
                
                <div class="text-14 text-light-1">7 Days Tour</div>
              </div>

              <h4 class="tourCard__title text-dark-1 text-18 lh-16 fw-500">
                <span>Best of Srilanka Tour</span>
              </h4>

              <p class="text-light-1 lh-14 text-14 mt-5"><strong>Service level:</strong> Upgraded</p>
              <p class="text-light-1 lh-14 text-14 mt-5"><strong>Activity level:</strong> Moderate</p>
              <p class="text-light-1 lh-14 text-14 mt-5"><strong> Group size:</strong> Private group</p>

              <div class="row justify-between items-center pt-15">
                

                <div class="col-auto">
                  <div class="text-14 text-light-1">
                    From
                    <span class="text-16 fw-500 text-dark-1">$999 Per Person</span>
                  </div>
                </div>
              </div>
            </div>
          </a>

        </div>

        <div data-anim-child="slide-up delay-4" class="col-xl-3 col-lg-3 col-sm-6">

          <a href="<?php echo e(route('countries-with-tomatina-tour')); ?>" class="tourCard -type-1 rounded-4 ">
            <div class="tourCard__image">

              <div class="cardImage ratio ratio-1:1">
                <div class="cardImage__content">

                  <img class="rounded-4 col-12" src="<?php echo e(asset('assets/img/tours/la-tomatina.jpg')); ?>" alt="image">


                </div>

                <div class="cardImage__wishlist">
                  <button class="button -blue-1 bg-white size-30 rounded-full shadow-2">
                    <i class="icon-heart text-12"></i>
                  </button>
                </div>


                <div class="cardImage__leftBadge">
                  <div class="py-5 px-15 rounded-right-4 text-12 lh-16 fw-500 uppercase bg-yellow-1 text-dark-1">
                    Top Rated
                  </div>
                </div>

              </div>

            </div>

            <div class="tourCard__content mt-10">
              <div class="d-flex items-center lh-14 mb-5">
                
                <div class="text-14 text-light-1">Spain - Paris - Amsterdam - Italy Tour</div>
              </div>

              <h4 class="tourCard__title text-dark-1 text-18 lh-16 fw-500">
                <span>4 Countries With Tomatina</span>
              </h4>

              <p class="text-light-1 lh-14 text-14 mt-5"><strong>Spain Only -</strong> PKR 875,000 Per Person</p>
              <p class="text-light-1 lh-14 text-14 mt-5"><strong>4 Countries Europe Tour -</strong> PKR 1,375,000 Per Person</p>

              <div class="row justify-between items-center pt-15">
                

                <div class="col-auto">
                  <div class="text-14 text-light-1">
                    From
                    <span class="text-16 fw-500 text-dark-1">PKR 1,375,000 Per Person</span>
                  </div>
                </div>
              </div>
            </div>
          </a>

        </div>

      </div>
    </div>
  </section>

  <section class="layout-pt-md layout-pb-md">
    <div data-anim-wrap class="container">
      <div data-anim-child="slide-up delay-1" class="row justify-center text-center">
        <div class="col-auto">
          <div class="sectionTitle -md">
            <h2 class="sectionTitle__title">Top Destinations</h2>
            <p class=" sectionTitle__text mt-5 sm:mt-0">These popular destinations have a lot to offer</p>
          </div>
        </div>
      </div>

      <div class="row y-gap-40 justify-between pt-40 sm:pt-20">

        <div data-anim-child="slide-up delay-3" class="col-xl-3 col-md-4 col-sm-6">

          <a href="#" class="citiesCard -type-3 d-block rounded-4 ">
            <div class="citiesCard__image ratio ratio-1:1">
              <img class="img-ratio js-lazy" src="#" data-src="<?php echo e(asset('assets/img/destinations/1.png')); ?>" alt="image">
            </div>

            <div class="citiesCard__content px-30 py-30">
              <h4 class="text-26 fw-600 text-white">Los Angeles</h4>
              
            </div>
          </a>

        </div>

        <div data-anim-child="slide-up delay-4" class="col-xl-6 col-md-4 col-sm-6">

          <a href="#" class="citiesCard -type-3 d-block rounded-4 h-full">
            <div class="citiesCard__image ">
              <img class="img-ratio js-lazy" src="#" data-src="<?php echo e(asset('assets/img/destinations/2.png')); ?>" alt="image">
            </div>

            <div class="citiesCard__content px-30 py-30">
              <h4 class="text-26 fw-600 text-white">London</h4>
              
            </div>
          </a>

        </div>

        <div data-anim-child="slide-up delay-5" class="col-xl-3 col-md-4 col-sm-6">

          <a href="#" class="citiesCard -type-3 d-block rounded-4 ">
            <div class="citiesCard__image ratio ratio-1:1">
              <img class="img-ratio js-lazy" src="#" data-src="<?php echo e(asset('assets/img/destinations/3.png')); ?>" alt="image">
            </div>

            <div class="citiesCard__content px-30 py-30">
              <h4 class="text-26 fw-600 text-white">Reykjavik</h4>
              
            </div>
          </a>

        </div>

        <div data-anim-child="slide-up delay-6" class="col-xl-6 col-md-4 col-sm-6">

          <a href="#" class="citiesCard -type-3 d-block rounded-4 h-full">
            <div class="citiesCard__image ">
              <img class="img-ratio js-lazy" src="#" data-src="<?php echo e(asset('assets/img/destinations/4.png')); ?>" alt="image">
            </div>

            <div class="citiesCard__content px-30 py-30">
              <h4 class="text-26 fw-600 text-white">Paris</h4>
              
            </div>
          </a>

        </div>

        <div data-anim-child="slide-up delay-7" class="col-xl-3 col-md-4 col-sm-6">

          <a href="#" class="citiesCard -type-3 d-block rounded-4 ">
            <div class="citiesCard__image ratio ratio-1:1">
              <img class="img-ratio js-lazy" src="#" data-src="<?php echo e(asset('assets/img/destinations/5.png')); ?>" alt="image">
            </div>

            <div class="citiesCard__content px-30 py-30">
              <h4 class="text-26 fw-600 text-white">Amsterdam</h4>
              
            </div>
          </a>

        </div>

        <div data-anim-child="slide-up delay-8" class="col-xl-3 col-md-4 col-sm-6">

          <a href="#" class="citiesCard -type-3 d-block rounded-4 ">
            <div class="citiesCard__image ratio ratio-1:1">
              <img class="img-ratio js-lazy" src="#" data-src="<?php echo e(asset('assets/img/destinations/6.png')); ?>" alt="image">
            </div>

            <div class="citiesCard__content px-30 py-30">
              <h4 class="text-26 fw-600 text-white">Istanbul</h4>
              
            </div>
          </a>

        </div>

      </div>
    </div>
  </section>

  <section class="layout-pt-md layout-pb-md">
    <div data-anim-wrap class="container">
        <div class="row y-gap-30 pt-40 sm:pt-20">
            <div data-anim-child="slide-up delay-1" class="col-xl-4 col-lg-4 col-sm-6">
                <div class="tourCard -type-1 rounded-4 ">
                    <div class="sectionTitle -md">
                        <h2 class="sectionTitle__title">Popular Airlines in Pakistan</h2>
                        <p class=" sectionTitle__text mt-5 sm:mt-0" style="font-size:22px;">Book cheap flights on your favourite airlines</p>
                    </div>
                </div>
            </div>

            <div data-anim-child="slide-up delay-2" class="col-xl-2 col-lg-2 col-sm-6">
                <div class="tourCard -type-1 rounded-4 ">
                    <img style="width: 150px;" src="<?php echo e(asset('assets/img/airline-img/pia.png')); ?>" alt="pia">
                    <img style="width: 150px; padding-top:10px;" src="<?php echo e(asset('assets/img/airline-img/emirates.png')); ?>" alt="pia">
                </div>
            </div>

            <div data-anim-child="slide-up delay-3" class="col-xl-2 col-lg-2 col-sm-6">
                <div class="tourCard -type-1 rounded-4 ">
                    <img style="width: 150px;" src="<?php echo e(asset('assets/img/airline-img/airblue.png')); ?>" alt="pia">
                    <img style="width: 150px; padding-top:10px;" src="<?php echo e(asset('assets/img/airline-img/airarabia.png')); ?>" alt="pia">
                </div>
            </div>

            <div data-anim-child="slide-up delay-4" class="col-xl-2 col-lg-2 col-sm-6">
                <div class="tourCard -type-1 rounded-4 ">
                    <img style="width: 150px;" src="<?php echo e(asset('assets/img/airline-img/sereneair.png')); ?>" alt="pia">
                    <img style="width: 150px; padding-top:10px;" src="<?php echo e(asset('assets/img/airline-img/flydubai.png')); ?>" alt="pia">
                </div>
            </div>

            <div data-anim-child="slide-up delay-4" class="col-xl-2 col-lg-2 col-sm-6">
                <div class="tourCard -type-1 rounded-4 ">
                    <img style="width: 150px;" src="<?php echo e(asset('assets/img/airline-img/flynas.png')); ?>" alt="pia">
                    <img style="width: 150px; padding-top:10px;" src="<?php echo e(asset('assets/img/airline-img/qatar.png')); ?>" alt="pia">
                </div>
            </div>
        </div>
    </div>
  </section>

  

  <section class="layout-pt-md layout-pb-lg">
    <div data-anim-wrap class="container">
      <div data-anim-child="slide-up" class="row y-gap-20 justify-between items-end">
        <div class="col-auto">
          <div class="sectionTitle -md">
            <h2 class="sectionTitle__title">Popular Routes</h2>
            <p class=" sectionTitle__text mt-5 sm:mt-0">Interdum et malesuada fames ac ante ipsum</p>
          </div>
        </div>

        <div class="col-auto">

          <a href="#" class="-md -yellow-new bg-dark-new button text-white">
            More <div class="icon-arrow-top-right ml-15"></div>
          </a>

        </div>
      </div>

      <div class="row y-gap-30 pt-40 sm:pt-20">

        <div data-anim-child="slide-up delay-1" class="col-12">
          <div class="px-20 py-20 rounded-4 border-light">
            <div class="row y-gap-30 justify-between xl:justify-">

              <div class="col-xl-4 col-lg-6">
                <div class="row y-gap-10 items-center">
                  <div class="col-sm-auto">
                    <img class="size-40" src="<?php echo e(asset('assets/img/flightIcons/1.png')); ?>" alt="image">
                  </div>

                  <div class="col">
                    <div class="row x-gap-20 items-end">
                      <div class="col-auto">
                        <div class="lh-15 fw-500">14:00</div>
                        <div class="text-15 lh-15 text-light-1">SAW</div>
                      </div>

                      <div class="col text-center">
                        <div class="flightLine">
                          <div></div>
                          <div></div>
                        </div>
                        <div class="text-15 lh-15 text-light-1 mt-10">4h 05m- Nonstop</div>
                      </div>

                      <div class="col-auto">
                        <div class="lh-15 fw-500">22:00</div>
                        <div class="text-15 lh-15 text-light-1">STN</div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>

              <div class="col-xl-4 col-lg-6">
                <div class="row y-gap-10 items-center">
                  <div class="col-sm-auto">
                    <img class="size-40" src="<?php echo e(asset('assets/img/flightIcons/2.png')); ?>" alt="image">
                  </div>

                  <div class="col">
                    <div class="row x-gap-20 items-end">
                      <div class="col-auto">
                        <div class="lh-15 fw-500">14:00</div>
                        <div class="text-15 lh-15 text-light-1">SAW</div>
                      </div>

                      <div class="col text-center">
                        <div class="flightLine">
                          <div></div>
                          <div></div>
                        </div>
                        <div class="text-15 lh-15 text-light-1 mt-10">4h 05m- Nonstop</div>
                      </div>

                      <div class="col-auto">
                        <div class="lh-15 fw-500">22:00</div>
                        <div class="text-15 lh-15 text-light-1">STN</div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>


              <div class="col-auto">
                <div class="d-flex items-center">
                  <div class="text-right mr-24">
                    <div class="lh-15 fw-500">US$934</div>
                    <div class="text-15 lh-15 text-light-1">16 deals</div>
                  </div>


                  <a href="#" class="button -outline-blue-1 px-30 h-50 text-dark-1">
                    View Deal <div class="icon-arrow-top-right ml-15"></div>
                  </a>

                </div>
              </div>
            </div>
          </div>
        </div>

        <div data-anim-child="slide-up delay-2" class="col-12">
          <div class="px-20 py-20 rounded-4 border-light">
            <div class="row y-gap-30 justify-between xl:justify-">

              <div class="col-xl-4 col-lg-6">
                <div class="row y-gap-10 items-center">
                  <div class="col-sm-auto">
                    <img class="size-40" src="<?php echo e(asset('assets/img/flightIcons/1.png')); ?>" alt="image">
                  </div>

                  <div class="col">
                    <div class="row x-gap-20 items-end">
                      <div class="col-auto">
                        <div class="lh-15 fw-500">14:00</div>
                        <div class="text-15 lh-15 text-light-1">SAW</div>
                      </div>

                      <div class="col text-center">
                        <div class="flightLine">
                          <div></div>
                          <div></div>
                        </div>
                        <div class="text-15 lh-15 text-light-1 mt-10">4h 05m- Nonstop</div>
                      </div>

                      <div class="col-auto">
                        <div class="lh-15 fw-500">22:00</div>
                        <div class="text-15 lh-15 text-light-1">STN</div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>

              <div class="col-xl-4 col-lg-6">
                <div class="row y-gap-10 items-center">
                  <div class="col-sm-auto">
                    <img class="size-40" src="<?php echo e(asset('assets/img/flightIcons/2.png')); ?>" alt="image">
                  </div>

                  <div class="col">
                    <div class="row x-gap-20 items-end">
                      <div class="col-auto">
                        <div class="lh-15 fw-500">14:00</div>
                        <div class="text-15 lh-15 text-light-1">SAW</div>
                      </div>

                      <div class="col text-center">
                        <div class="flightLine">
                          <div></div>
                          <div></div>
                        </div>
                        <div class="text-15 lh-15 text-light-1 mt-10">4h 05m- Nonstop</div>
                      </div>

                      <div class="col-auto">
                        <div class="lh-15 fw-500">22:00</div>
                        <div class="text-15 lh-15 text-light-1">STN</div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>


              <div class="col-auto">
                <div class="d-flex items-center">
                  <div class="text-right mr-24">
                    <div class="lh-15 fw-500">US$934</div>
                    <div class="text-15 lh-15 text-light-1">16 deals</div>
                  </div>


                  <a href="#" class="button -outline-blue-1 px-30 h-50 text-dark-1">
                    View Deal <div class="icon-arrow-top-right ml-15"></div>
                  </a>

                </div>
              </div>
            </div>
          </div>
        </div>

        <div data-anim-child="slide-up delay-3" class="col-12">
          <div class="px-20 py-20 rounded-4 border-light">
            <div class="row y-gap-30 justify-between xl:justify-">

              <div class="col-xl-4 col-lg-6">
                <div class="row y-gap-10 items-center">
                  <div class="col-sm-auto">
                    <img class="size-40" src="<?php echo e(asset('assets/img/flightIcons/1.png')); ?>" alt="image">
                  </div>

                  <div class="col">
                    <div class="row x-gap-20 items-end">
                      <div class="col-auto">
                        <div class="lh-15 fw-500">14:00</div>
                        <div class="text-15 lh-15 text-light-1">SAW</div>
                      </div>

                      <div class="col text-center">
                        <div class="flightLine">
                          <div></div>
                          <div></div>
                        </div>
                        <div class="text-15 lh-15 text-light-1 mt-10">4h 05m- Nonstop</div>
                      </div>

                      <div class="col-auto">
                        <div class="lh-15 fw-500">22:00</div>
                        <div class="text-15 lh-15 text-light-1">STN</div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>

              <div class="col-xl-4 col-lg-6">
                <div class="row y-gap-10 items-center">
                  <div class="col-sm-auto">
                    <img class="size-40" src="<?php echo e(asset('assets/img/flightIcons/2.png')); ?>" alt="image">
                  </div>

                  <div class="col">
                    <div class="row x-gap-20 items-end">
                      <div class="col-auto">
                        <div class="lh-15 fw-500">14:00</div>
                        <div class="text-15 lh-15 text-light-1">SAW</div>
                      </div>

                      <div class="col text-center">
                        <div class="flightLine">
                          <div></div>
                          <div></div>
                        </div>
                        <div class="text-15 lh-15 text-light-1 mt-10">4h 05m- Nonstop</div>
                      </div>

                      <div class="col-auto">
                        <div class="lh-15 fw-500">22:00</div>
                        <div class="text-15 lh-15 text-light-1">STN</div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>


              <div class="col-auto">
                <div class="d-flex items-center">
                  <div class="text-right mr-24">
                    <div class="lh-15 fw-500">US$934</div>
                    <div class="text-15 lh-15 text-light-1">16 deals</div>
                  </div>


                  <a href="#" class="button -outline-blue-1 px-30 h-50 text-dark-1">
                    View Deal <div class="icon-arrow-top-right ml-15"></div>
                  </a>

                </div>
              </div>
            </div>
          </div>
        </div>

        <div data-anim-child="slide-up delay-4" class="col-12">
          <div class="px-20 py-20 rounded-4 border-light">
            <div class="row y-gap-30 justify-between xl:justify-">

              <div class="col-xl-4 col-lg-6">
                <div class="row y-gap-10 items-center">
                  <div class="col-sm-auto">
                    <img class="size-40" src="<?php echo e(asset('assets/img/flightIcons/1.png')); ?>" alt="image">
                  </div>

                  <div class="col">
                    <div class="row x-gap-20 items-end">
                      <div class="col-auto">
                        <div class="lh-15 fw-500">14:00</div>
                        <div class="text-15 lh-15 text-light-1">SAW</div>
                      </div>

                      <div class="col text-center">
                        <div class="flightLine">
                          <div></div>
                          <div></div>
                        </div>
                        <div class="text-15 lh-15 text-light-1 mt-10">4h 05m- Nonstop</div>
                      </div>

                      <div class="col-auto">
                        <div class="lh-15 fw-500">22:00</div>
                        <div class="text-15 lh-15 text-light-1">STN</div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>

              <div class="col-xl-4 col-lg-6">
                <div class="row y-gap-10 items-center">
                  <div class="col-sm-auto">
                    <img class="size-40" src="<?php echo e(asset('assets/img/flightIcons/2.png')); ?>" alt="image">
                  </div>

                  <div class="col">
                    <div class="row x-gap-20 items-end">
                      <div class="col-auto">
                        <div class="lh-15 fw-500">14:00</div>
                        <div class="text-15 lh-15 text-light-1">SAW</div>
                      </div>

                      <div class="col text-center">
                        <div class="flightLine">
                          <div></div>
                          <div></div>
                        </div>
                        <div class="text-15 lh-15 text-light-1 mt-10">4h 05m- Nonstop</div>
                      </div>

                      <div class="col-auto">
                        <div class="lh-15 fw-500">22:00</div>
                        <div class="text-15 lh-15 text-light-1">STN</div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>


              <div class="col-auto">
                <div class="d-flex items-center">
                  <div class="text-right mr-24">
                    <div class="lh-15 fw-500">US$934</div>
                    <div class="text-15 lh-15 text-light-1">16 deals</div>
                  </div>


                  <a href="#" class="button -outline-blue-1 px-30 h-50 text-dark-1">
                    View Deal <div class="icon-arrow-top-right ml-15"></div>
                  </a>

                </div>
              </div>
            </div>
          </div>
        </div>

      </div>
    </div>
  </section>


<?php $__env->stopSection(); ?>
<?php $__env->startSection('customJs'); ?>
<script
  src="https://code.jquery.com/jquery-3.7.1.js"
  integrity="sha256-eKhayi8LEQwp4NKxN+CfCh+3qOVUtJn3QNZ0TciWLP4="
  crossorigin="anonymous"></script>
<script>
    $(document).ready(function() {
        $('.select2').select2();
    });
</script>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\flying_experto\resources\views/index.blade.php ENDPATH**/ ?>