@extends('layout.app')

@section('content')

    <section class="py-10 d-flex items-center bg-light-2" style="margin-top: 6rem;">
        <div class="container">
          <div class="row y-gap-10 items-center justify-between">
            <div class="col-auto">
              <div class="row x-gap-10 y-gap-5 items-center text-14 text-light-1">
                <div class="col-auto">
                  <div class=""><a href="{{route('home')}}">Home</a></div>
                </div>
                <div class="col-auto">
                  <div class="">></div>
                </div>
                <div class="col-auto">
                  <div class=""><a href="{{route('all-tours')}}">Tours</a></div>
                </div>
                <div class="col-auto">
                  <div class="">></div>
                </div>
                <div class="col-auto">
                  <div class="text-dark-1">Baku & Istanbul Combo Tour</div>
                </div>
              </div>
            </div>

            <div class="col-auto">
              <a href="{{route('all-tours')}}" class="text-14 text-dark-1 underline">All Tours</a>
            </div>
          </div>
        </div>
    </section>

    <section class="pt-40">
        <div class="container">
            <div class="row y-gap-15 justify-between items-end">
                <div class="col-auto">
                    <h1 class="text-30 fw-600">Baku & Istanbul Combo Tour</h1>
                </div>
            </div>
        </div>
    </section>

    <section class="pt-40 js-pin-container mb-30">
        <div class="container">
          <div class="row y-gap-30">
            <div class="col-lg-7">
              <div class="relative d-flex justify-center overflow-hidden js-section-slider" data-slider-cols="base-1" data-nav-prev="js-img-prev" data-nav-next="js-img-next">
                <div class="swiper-wrapper">
                  <div class="swiper-slide">
                    <img src="{{asset('assets/img/tours/baku/1.jpg')}}" alt="image" class="rounded-4 col-12 h-full object-cover">
                  </div>

                  <div class="swiper-slide">
                    <img src="{{asset('assets/img/tours/baku/2.jpg')}}" alt="image" class="rounded-4 col-12 h-full object-cover">
                  </div>

                  <div class="swiper-slide">
                    <img src="{{asset('assets/img/tours/baku/3.jpg')}}" alt="image" class="rounded-4 col-12 h-full object-cover">
                  </div>

                  <div class="swiper-slide">
                    <img src="{{asset('assets/img/baku/1.jpg')}}" alt="image" class="rounded-4 col-12 h-full object-cover">
                  </div>

                </div>

                <div class="absolute h-full col-11">

                  <button class="section-slider-nav -prev flex-center button -blue-1 bg-white shadow-1 size-40 rounded-full sm:d-none js-img-prev">
                    <i class="icon icon-chevron-left text-12"></i>
                  </button>

                  <button class="section-slider-nav -next flex-center button -blue-1 bg-white shadow-1 size-40 rounded-full sm:d-none js-img-next">
                    <i class="icon icon-chevron-right text-12"></i>
                  </button>

                </div>

                <div class="absolute h-full col-12 z-2 px-20 py-20 d-flex justify-end items-end">
                  <a href="{{asset('assets/img/tours/baku/1.jpg')}}" class="button -blue-1 px-24 py-15 bg-white text-dark-1 js-gallery" data-gallery="gallery2">
                    See Photos
                  </a>
                  <a href="{{asset('assets/img/tours/baku/1.jpg')}}" class="js-gallery" data-gallery="gallery2"></a>
                  <a href="{{asset('assets/img/tours/baku/2.jpg')}}" class="js-gallery" data-gallery="gallery2"></a>
                  <a href="{{asset('assets/img/tours/baku/3.jpg')}}" class="js-gallery" data-gallery="gallery2"></a>
                  <a href="{{asset('assets/img/tours/baku/1.jpg')}}" class="js-gallery" data-gallery="gallery2"></a>
                </div>
              </div>

              <h3 class="text-22 fw-500 mt-30">
                Key Points
              </h3>

              <div class="row y-gap-30 justify-between pt-20">

                <div class="col-md-auto col-6">
                  <div class="d-flex">
                    <i class="icon-clock text-22 text-blue-1 mr-10"></i>
                    <div class="text-15 lh-15">
                      Duration:<br> 7 Days
                    </div>
                  </div>
                </div>

                <div class="col-md-auto col-6">
                  <div class="d-flex">
                    <i class="icon-customer text-22 text-blue-1 mr-10"></i>
                    <div class="text-15 lh-15">
                      Service level:<br> Upgraded
                    </div>
                  </div>
                </div>

                <div class="col-md-auto col-6">
                  <div class="d-flex">
                    <i class="icon-route text-22 text-blue-1 mr-10"></i>
                    <div class="text-15 lh-15">
                        Activity level:<br> Moderate
                    </div>
                  </div>
                </div>

                <div class="col-md-auto col-6">
                  <div class="d-flex">
                    <i class="icon-access-denied text-22 text-blue-1 mr-10"></i>
                    <div class="text-15 lh-15">
                        Group size:  <br> Private group
                    </div>
                  </div>
                </div>
                <div class="col-md-auto col-6">
                    <div class="d-flex">
                      <i class="icon-access-denied text-22 text-blue-1 mr-10"></i>
                      <div class="text-15 lh-15">
                          Price:  <br> $1000 Per Person
                      </div>
                    </div>
                </div>

              </div>

              <div class="border-top-light mt-40 mb-40"></div>

              <div class="row x-gap-40 y-gap-40">
                <div class="col-12">
                  <h3 class="text-22 fw-500">Activities</h3>
                </div>

                <div class="col-6">
                  <h5 class="text-16 fw-500">Tour Includes</h5>
                  <ul class="list-disc text-15 mt-10">
                    <li>Baku + Turkey Visa Support</li>
                    <li>Airport Transfer</li>
                    <li>Hotel Accommodation on twin share basis</li>
                    <li>Tours mentioned in the Itinerary</li>
                    <li>English & Urdu speaking Guide</li>
                  </ul>
                </div>
                <div class="col-6">
                    <h5 class="text-16 fw-500">Not Includes</h5>
                    <ul class="list-disc text-15 mt-10">
                      <li>International Return Air Ticket</li>
                      <li>All Personal expenses</li>
                      <li>Tickets pass if any</li>
                    </ul>
                  </div>
              </div>
              <div class="row x-gap-40 y-gap-40">
                <div class="col-auto">
                  <h3 class="text-22 fw-500">ITINERARY:</h3>
                </div>
              </div>
              <div class="row x-gap-40 y-gap-40 justify-between pt-20">
                <div class="col-lg-6 col-md-6">
                  <div class="fw-500 mb-10">Day1</div>
                  <div class="text-15">
                      ARRIVAL IN BAKU | WARM WELCOME | HOTEL CHECK-IN
                  </div>
                </div>
                <div class="col-lg-6 col-md-6">
                  <div class="fw-500 mb-10">Day2</div>
                  <div class="text-15">
                      <strong>FULL DAY BAKU CITY TOUR</strong> <br>
                      <strong>TOP ATTRACTIONS:</strong> Highland Park. Flame Towers, Icheri Sheher, Maiden Tower, Shirvanshahs Palace. History Museum, Nizami Museum of Literature, Nizami Street, Fountain Square, House of Government, Baku Boulevard, Carpet Museum (out view), Little Venice & Baku Ferris Wheel Visit.
                  </div>
                </div>
                <div class="col-lg-6 col-md-6">
                  <div class="fw-500 mb-10">Day3</div>
                  <div class="text-15">
                      <strong>FULL DAY GABALA TOUR</strong> <br>
                      <strong>TOP ATTRACTIONS:</strong> Tufandag Summer – Winter Recreation Complex-Ropeways, Gabaland Entertainment Center, Gabala Archaeological Center, Excursion to Seven Beauties Waterfall & Gabala Nohur lake.
                  </div>
                </div>
                <div class="col-lg-6 col-md-6">
                  <div class="fw-500 mb-10">Day4</div>
                  <div class="text-15">
                      DEPARTURE & ARRIVAL IN ISTANBUL
                  </div>
                </div>
                <div class="col-lg-6 col-md-6">
                  <div class="fw-500 mb-10">Day5</div>
                  <div class="text-15">
                      <strong>HALF DAY ISTANBUL CITY TOUR</strong>
                      <strong>TOP ATTRACTIONS:</strong> Blue Mosque, Hagia Sophia, Top Kapi Palace, Grand Bazar & Spice Bazar.
                  </div>
                </div>
                <div class="col-lg-6 col-md-6">
                  <div class="fw-500 mb-10">Day6</div>
                  <div class="text-15">
                      FULL DAY PRINCES ISLAND TOUR WITH LUNCH
                  </div>
                </div>
                <div class="col-lg-6 col-md-6">
                  <div class="fw-500 mb-10">Day7</div>
                  <div class="text-15">
                      FINAL DEPARTURE WITH SWEET MEMORIES
                  </div>
                </div>
              </div>
            </div>
            <div class="col-lg-5">
                <div class="js-pin-content">
                    <div class="row">
                        <div class="col-lg-12">
                            <img src="{{asset('assets/img/tours/baku/baku-tour.jpg')}}" alt="">
                            <h3 class="text-22 fw-500">Baku & Istanbul Combo Tour  Registration Form</h3>
                        </div>
                    </div>
                    <form action="{{ route('submit-tour') }}" method="get">
                        @csrf
                        <div class="row">
                            <div class="col-lg-6 mt-30">
                                <label for="name">Name</label>
                                <input style="border: 1px solid #f5f5f5; padding-left:10px;" type="text" name="name" id="name" placeholder="Enter Name" value="{{ old('name') }}" required>
                            </div>
                            <div class="col-lg-6 mt-30">
                                <label for="email">Email</label>
                                <input style="border: 1px solid #f5f5f5; padding-left:10px;" type="email" name="email" id="email" placeholder="Enter Email" value="{{ old('email') }}" required>
                            </div>
                            <div class="col-lg-6 mt-30">
                                <label for="phone">Phone No.</label>
                                <input style="border: 1px solid #f5f5f5; padding-left:10px;" type="text" name="phone" id="phone" placeholder="Enter Phone No." value="{{ old('phone') }}" required>
                            </div>
                            <div class="col-lg-6 mt-30">
                                <label for="no_of_traveler">No. of Travelers</label>
                                <input style="border: 1px solid #f5f5f5; padding-left:10px;" type="text" name="no_of_traveler" id="no_of_traveler" placeholder="Enter No. of Travelers" value="{{ old('no_of_traveler') }}" required>
                            </div>
                            <div class="col-lg-6 mt-30">
                                <label for="selected_tour">Where would you like to Travel?</label>
                                <select style="border: 1px solid #f5f5f5; padding-left:10px;" name="selected_tour" id="selected_tour" required>
                                    <option value="" disabled>Select Tour</option>
                                    <option value="thailand"> Thailand Tour </option>
                                    <option value="baku_and_istanbul" selected> Baku & Istanbul Combo Tour </option>
                                    <option value="srilanka">Best of Srilanka Tour</option>
                                    <option value="tomatina">4 Countries With Tomatina</option>
                                </select>
                            </div>
                            <div class="col-lg-6 mt-30">
                                <label for="depart_date">Departure Date</label>
                                <input type="date" name="depart_date" id="depart" required value="{{ old('depart_date') }}"  required>
                            </div>
                            <div class="col-lg-12 mt-30">
                                <label for="message">Message</label>
                                <textarea style="border: 1px solid #f5f5f5; padding-left:10px;" name="message" id="message" cols="30" rows="3" placeholder="Write your message">{{ old('message') }}</textarea>
                            </div>
                            <div class="col-lg-12">
                                <div class="button-item">
                                    <button type="submit" class="mainSearch__submit button -yellow-new py-15 px-35 col-12 rounded-4 bg-dark-new text-white">
                                        Submit
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
          </div>
        </div>
    </section>

@endsection
@section('customJs')

@endsection
